/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap.JICP;

import jade.core.Profile;
import jade.imtp.leap.ICP;
import jade.imtp.leap.ICPException;
import jade.imtp.leap.JICP.Connection;
import jade.imtp.leap.JICP.ConnectionFactory;
import jade.imtp.leap.JICP.JICPPacket;
import jade.imtp.leap.JICP.JICPPeer;
import jade.util.Logger;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Hashtable;

public class JICPServer
extends Thread {
    public static final String ACCEPT_LOCAL_HOST_ONLY = "jade_imtp_leap_JICP_JICPServer_acceptlocalhostonly";
    private static final int LISTENING = 0;
    private static final int TERMINATING = 1;
    private int state = 0;
    private String host;
    private ServerSocket server;
    private ICP.Listener cmdListener;
    private int mediatorCnt = 1;
    private Hashtable mediators = new Hashtable();
    private int handlersCnt = 0;
    private int maxHandlers;
    private ConnectionFactory connFactory;
    private Logger myLogger;

    public JICPServer(Profile p, JICPPeer myPeer, ICP.Listener l, ConnectionFactory f, int max) throws ICPException {
        int idLength;
        this.cmdListener = l;
        this.connFactory = f;
        this.maxHandlers = max;
        this.myLogger = Logger.getMyLogger(this.getClass().getName());
        StringBuffer sb = null;
        String peerID = myPeer.getID();
        if (peerID != null) {
            sb = new StringBuffer(peerID);
            sb.append('-');
            idLength = sb.length();
        } else {
            sb = new StringBuffer();
            idLength = 0;
        }
        sb.append("local-host");
        this.host = p.getParameter(sb.toString(), null);
        boolean acceptLocalHostOnly = false;
        if (this.host == null) {
            sb.setLength(idLength);
            sb.append("remote-url");
            String remoteURL = p.getParameter(sb.toString(), null);
            this.host = remoteURL != null ? myPeer.getAddress(remoteURL) : Profile.getDefaultNetworkName();
        } else if (Profile.isLocalHost(this.host)) {
            acceptLocalHostOnly = p.getBooleanProperty(ACCEPT_LOCAL_HOST_ONLY, false);
        } else {
            throw new ICPException("Error: Not possible to launch JADE on a remote host (" + this.host + "). Check the -host and -local-host options.");
        }
        int port = 1099;
        boolean changePortIfBusy = !p.getBooleanProperty("main", true);
        sb.setLength(idLength);
        sb.append("local-port");
        String strPort = p.getParameter(sb.toString(), null);
        try {
            port = Integer.parseInt(strPort);
        }
        catch (Exception e) {
            try {
                port = Integer.parseInt(peerID);
            }
            catch (Exception e1) {
                // empty catch block
            }
        }
        this.server = myPeer.getServerSocket(acceptLocalHostOnly ? this.host : null, port, changePortIfBusy);
        this.setDaemon(true);
        this.setName("JICPServer-" + this.getLocalPort());
    }

    public int getLocalPort() {
        return this.server.getLocalPort();
    }

    public String getLocalHost() {
        return this.host;
    }

    public synchronized void shutdown() {
        if (this.myLogger.isLoggable(5)) {
            this.myLogger.log(5, "Shutting down JICPServer...");
        }
        this.state = 1;
        try {
            this.server.close();
            this.join();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
    }

    public void run() {
        while (this.state != 1) {
            try {
                Socket s = this.server.accept();
                InetAddress addr = s.getInetAddress();
                int port = s.getPort();
                if (this.myLogger.isLoggable(3)) {
                    this.myLogger.log(3, "Incoming connection from " + addr + ":" + port);
                }
                Connection c = this.connFactory.createConnection(s);
                new ConnectionHandler(c, addr, port).start();
            }
            catch (InterruptedIOException e) {
            }
            catch (Exception e) {
                if (this.state != 0) continue;
                if (this.myLogger.isLoggable(9)) {
                    this.myLogger.log(9, "Problems accepting a new connection");
                }
                e.printStackTrace();
                this.state = 1;
            }
        }
        if (this.myLogger.isLoggable(5)) {
            this.myLogger.log(5, "JICPServer terminated");
        }
        try {
            this.server.close();
        }
        catch (IOException io) {
            if (this.myLogger.isLoggable(9)) {
                this.myLogger.log(9, "I/O error closing the server socket");
            }
            io.printStackTrace();
        }
        this.server = null;
    }

    public void tick(long currentTime) {
    }

    class ConnectionHandler
    extends Thread {
        private Connection c;
        private InetAddress addr;
        private int port;

        public ConnectionHandler(Connection c, InetAddress addr, int port) {
            this.c = c;
            this.addr = addr;
            this.port = port;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            JICPServer.this.handlersCnt++;
            if (JICPServer.this.myLogger.isLoggable(3)) {
                JICPServer.this.myLogger.log(3, "CommandHandler started");
            }
            boolean closeConnection = true;
            int status = 0;
            byte type = 0;
            try {
                boolean loop = false;
                do {
                    JICPPacket pkt = this.c.readPacket();
                    JICPPacket reply = null;
                    status = 1;
                    type = pkt.getType();
                    switch (type) {
                        case 0: 
                        case 1: {
                            String recipientID = pkt.getRecipientID();
                            if (JICPServer.this.myLogger.isLoggable(3)) {
                                JICPServer.this.myLogger.log(3, "Recipient: " + recipientID);
                            }
                            if (recipientID != null) break;
                            loop = true;
                            if (type == 0) {
                                if (JICPServer.this.myLogger.isLoggable(3)) {
                                    JICPServer.this.myLogger.log(3, "Passing incoming COMMAND to local listener");
                                }
                                byte[] rsp = JICPServer.this.cmdListener.handleCommand(pkt.getData());
                                byte dataInfo = 0;
                                if (JICPServer.this.handlersCnt >= JICPServer.this.maxHandlers) {
                                    dataInfo = (byte)(dataInfo | 0x40);
                                    loop = false;
                                }
                                reply = new JICPPacket(1, dataInfo, rsp);
                            }
                            if ((pkt.getInfo() & 0x40) == 0) break;
                            loop = false;
                            break;
                        }
                        default: {
                            if (JICPServer.this.myLogger.isLoggable(9)) {
                                JICPServer.this.myLogger.log(9, "Uncorrect JICP data type: " + pkt.getType());
                            }
                            reply = new JICPPacket("Uncorrect JICP data type: " + pkt.getType(), null);
                        }
                    }
                    status = 2;
                    if (reply != null) {
                        this.c.writePacket(reply);
                    }
                    status = 3;
                } while (loop);
                return;
            }
            catch (Exception e) {
                switch (status) {
                    case 0: {
                        if (JICPServer.this.myLogger.isLoggable(10)) {
                            JICPServer.this.myLogger.log(10, "Communication error reading incoming packet from " + this.addr + ":" + this.port);
                        }
                        e.printStackTrace();
                        return;
                    }
                    case 1: {
                        if (JICPServer.this.myLogger.isLoggable(10)) {
                            JICPServer.this.myLogger.log(10, "Error handling incoming packet");
                        }
                        e.printStackTrace();
                        if (type != 0) return;
                        if (this.c == null) return;
                        try {
                            this.c.writePacket(new JICPPacket("Unexpected error", e));
                            return;
                        }
                        catch (IOException ioe) {
                            if (!JICPServer.this.myLogger.isLoggable(9)) return;
                            JICPServer.this.myLogger.log(9, "Can't send back error indication " + ioe);
                            return;
                        }
                    }
                    case 2: {
                        if (!JICPServer.this.myLogger.isLoggable(10)) return;
                        JICPServer.this.myLogger.log(10, "Communication error writing return packet to " + this.addr + ":" + this.port + " [" + e.toString() + "]");
                        return;
                    }
                    case 3: {
                        if (e instanceof EOFException) {
                            if (!JICPServer.this.myLogger.isLoggable(5)) return;
                            JICPServer.this.myLogger.log(5, "Client " + this.addr + ":" + this.port + " has closed the connection.");
                            return;
                        }
                        if (!JICPServer.this.myLogger.isLoggable(5)) return;
                        JICPServer.this.myLogger.log(5, "Unexpected client " + this.addr + ":" + this.port + " termination. " + e.toString());
                        return;
                    }
                }
                return;
            }
            finally {
                try {
                    if (closeConnection) {
                        if (JICPServer.this.myLogger.isLoggable(3)) {
                            JICPServer.this.myLogger.log(3, "Closing connection with " + this.addr + ":" + this.port);
                        }
                        this.c.close();
                    }
                }
                catch (IOException io) {
                    if (JICPServer.this.myLogger.isLoggable(8)) {
                        JICPServer.this.myLogger.log(8, "I/O error while closing the connection");
                    }
                    io.printStackTrace();
                }
                JICPServer.this.handlersCnt--;
            }
        }
    }
}

